/*------------------------------------------------------------------------------*
 * File Name:TEMPLATEORGANIZER.C												*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 09/27/05 SPLITTER_INIT_SIZE_ON_READY									*
 * Jasmine 11/21/05 QA70-8347 v8.0339 SAVE_FULL_PATH							*
 * Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX							*
 * Jasmine 11/24/05 v8.0339 TEMPLATE_HAS_NO_PICTURE								*
 * Jasmine 12/19/05 v8.0349 COMPARE_INI_MODIFICATION_TIME_WITH_XML				*
 * Jasmine 12/19/05 v8.0349 MODIFICATION_ON_BUTTONS								*
 * Jasmine 12/26/05 DBCLICK_RENAME												*
 * Jasmine 12/26/05 CHANGE_BTN_STATUS											*
 * Jasmine 12/26/05 ADD_CONTEXT_MENU											*
 * Jasmine 12/26/05 PICT_NO_PREVIEW												*	
 * Jasmine 12/05/27 QA70-8347 v8.0349 CALLED_BY_FINDFUNCTION					*
 * Jasmine 12/28/05 QA70-6475 v8.0351 REMEMBER_LAST_SELECTION					*
 * Jasmine 12/29/05 QA70-8347 v8.0351 OPEN_PLOT_SETUP_DIALOG					*
 * CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER			*
 * Jasmine 02/05/06 QA70-8498 v8.0364 TEMPLATE_INFO_INTERNAL_ACCESS_NAME_CHANGE	*
 * Jasmine 02/06/06 BLOCK_IN_DEL_SECTION										*
 * Jasmine 03/16/06 v8.0375 FORCE_TO_CALL_RESIZE								*
 * Hong 7/27/06	ADD_FILEPATH_AND_DATEMODIFY										*
 * Hong 7/28/06 FIX_USER_CUSTOM_NO_PREVIEW										*
 * Hong 7/31/06 FIX_TEMPLATE_LIBRARY_TITLE										*
 * Jasmine 08/09/06 LOOK_FOR_EMF_FIRST											*
 * Jasmine 08/10/06 LOAD_DESCRIPTION											*
 * DSC 8/4/06 QA70-8883 SAVE_TEMPLATE_FROM_ORIGINC								*
 * Jasmine 08/17/06 CLEAN_UP_CODE												*
 * Jasmine 08/22/06 BMP_NO_STRETCH												*
 * Jasmine 09/30/06 MECHANISM_CHANGE											*
 * Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI						*
 * Jasmine 10/17/06 BUILT_IN_TEMPLATE_INI_SYSTEM_FOLDER							*
 * Jasmine 11/22/06 REMOVE_TEMPLATE_NODE_IF_FILE_INVALID						*
 * Jasmine 11/25/06 RESTORE_DEL_TEMPLATE										*
 * Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 * Jasmine 07/03/07 ON_ROW_CHANGE_AFTER_SET_READY								*
 * Jake 07/11/07 FIX_FAILED_TO_LOAD_NO_PREVIEW_WHEN_SELECT_GRAPH				*
 * Jake 07/11/07 LOAD_NEW_IMAGE_FOR_NO_PREVIEW									*
 * Jake 07/13/07 FIX_FAILED_TO_LOAD_NO_PREVIEW_WHEN_SELECT_GRAPH_ONECE_MORE		*
 * Jasmine 07/30/07 #8854 SHOW_TEMPLATE_UNDER_GROUP_FOLDER						*
 * Jasmine 07/31/07 ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY						*
 * Jasmine 07/31/07 MESSAGEBOX_SHOULD_USE_PARENT_HWND							*
 * Jasmine 08/15/07 QA80-10155 NO_MODIFICATION_TO_GROUP_FOLDER_FILE				*
 * Folger 08/22/07 COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML						*
 * Folger 08/23/07 COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE							*
 * Folger 08/24/07 FIND_TEMPLATE_AND_CATEGORY_IN_M_TRTP							*
 * Folger 09/04/07 USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL					*
 * Folger 09/06/07 MORE_CONTROL_OF_BUTTONS_STATUS								*
 * Jasmine 09/11/07 ADD_NEW_WINDOW_FOR_WKS_AND_MATRIX							*
 * Jasmine 09/11/07 COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER						*	
 * Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML							*
 * Folger 09/30/07 QA70-10464 CLOSE_ORGANIZER_AFTER_PLOT_SETUP_SUCCESSFULLY		*
 * Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
 * Folger 11/10/07 FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE				*
 * Folger 01/22/08 SHOULD_NOT_RENAME_CATEGORY_WITH_SYSTEM_OR_GROUP_TEMPLATE		*
 * Folger 01/23/08 QA70-10980 MVOE_TEMPLATE_TO_SPECIFIC_CATEGORY				*
 * Folger 01/23/08 QA70-10980 ADD_NEW_TEMPLATE_AND_NEW_CATEGORY_BUTTON			*
 *	Hong 06/16/08 v8.0885 FIX_SPLITTER_GUI_FAIL_REFRESH_IF_USER_CANCEL			*
 *	Folger 12/17/08 QA80-12749 v8.0987d PLOT_MRU_LIST_SHOULD_UPDATE_THAT_PLOTS_IN_TEMPLATE_LIBRARY
 *	Folger 12/22/08 QA80-12807-S3 v8.0989c ADD_MENU_MRU_LIST_FOR_MATRIX			*
 *	Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER			*
 *	Kyle 03/23/2009 QA80-13299 FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
 *	Kyle 03/27/2009 TEMPORARY_SOLUTION_TO_GET_PLOT_TYPE_FROM_TEMPLATE			*
 *	Kyle 04/01/2009 HANDLE_SPECIAL_PLOT_TYPE_IN_TEMPLATE_ORGANIZER				*
 *	Kyle 04/08/2009 QA80-13299 MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
 *	Kyle 04/08/2009 QA80-13299 TO_GET_DIALOG_MIN_SIZE_BY_SIZE_OF_BUTTONS		*
 *	Kyle 04/15/2009 QA80-13405 CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_IT
 *	ML 5/8/2009 QA70-13584 MUST_PASS_QUESTIONMARK_FOR_PROPER_PLOT_CREATION		*
 *	Folger 05/27/09 QA80-11779 DELETE_USER_DEFINED_TEMPLATE_FROM_TEMPLATE_LIBRARY_SHOULD_REMOVE_FILE
 *	Jasmine 07/27/09 QA80-P3 TERNARY_PLOT_NEED_PLOT_TYPE_ID						*
 *  Iris 8/07/2009 NEED_ADD_WINDROSERAW_TO_TEMPLATE_LIB							*
 *	Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC				*
 *	Jasmine 09/07/09 QA81-14237-P6 BASE_TYPE_IDM_PLOT_TRI_CONTOUR_AND_LAYER_BIT_PCD_LAYER_TRI_MEAN_IDM_PLOT_TERNARY_CONTOUR
 *	Folger 09/15/09 SPLITTER_CONTROL_MIXED_UP_AFTER_CLICK_CANCEL_FROM_ADD_DIALOG*
 *	Folger 09/24/09 XF_BASED_PLOTTING_FROM_TEMPLATE_LIBRARY_ALWAYS_UPDATE_UNKNOW_KEYWORD_INTO_PLOTTING_MRU
 *	Jasmine 10/15/09 QA81-14470 WINDROSE_NEED_PLOTTYPE_COLUMN_STACK				*
 *	Jasmine 10/22/09 QA81-14470-P3 RX_THETAY_POLAR_GRAPH_NEED_PLOT_ID_FROM_STYLE_HOLDER
 *	Jasmine 01/15/10 LAST_SEL_BLOCK_PLOTSETUP_OPEN								*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <Profiler.h>
#define HOUR_GLASS			waitCursor junk;
#define PROFILE_HRGLASS		HOUR_GLASS

#define  _DMSG(_str)  //out_str(_str);
#define  _DMSG_S(_str) //out_str(_str);
#include "DialogEx.h"
//#include "TreeEditSplitter.h"

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#include "SplitterControl.h"
//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
// maybe not needed, make compile faster
//#include "GraphPageControl.h"
//-----

#include "TemplateOrganizer.h"
#include "TPListSplitter.h"

#include <ocu.h>		//------ Folger 08/23/07 COPY_TEMPLATE_FILE_WHEN_ADD_TEMPLATE

///Jasmine 09/11/07 COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
#define STR_DLG_NAME 	_L("Template Library")//"Template Organizer"
//------ Folger 01/23/08 QA70-10980 ADD_NEW_TEMPLATE_AND_NEW_CATEGORY_BUTTON
//#define COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
//------
///End COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER


///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI, no need
/*
///Jasmine 12/19/05 COMPARE_INI_MODIFICATION_TIME_WITH_XML
static bool is_ini_file_newer()
{
	string strXMLFile = STR_USER_PATH + "Template.xml";
	string strINIFile = STR_USER_PATH + "Template.ini" ;
	string strXMLFileDate = GetFileModificationDate(strXMLFile, LDF_YYMMDD_AND_HHMMSS);
	string strINIFileDate = GetFileModificationDate(strINIFile, LDF_YYMMDD_AND_HHMMSS);
	bool bRet = (1 == strINIFileDate.CompareNoCase(strXMLFileDate))? true : false;
	return bRet;
}
///End
*/
//------ Folger 09/06/07 MORE_CONTROL_OF_BUTTONS_STATUS
enum
{
	SEL_CHANGE_INIT 		= 0x00000001,
	SEL_CHANGE_USER_FLAG	= 0x00000002,
};
//------ End MORE_CONTROL_OF_BUTTONS_STATUS

///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
#define MIN_MAIN_DLG_HEIGHT 	300
#define MIN_MAIN_DLG_WIDTH 		550
///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER


class TemplateOrganizerDlg : public ResizeDialog
{	
public:
	//---- CPY 10/5/05 CLASS_FORWARD_DECLARATION_MUST_USE_PTR
	TemplateOrganizerDlg();
	~TemplateOrganizerDlg();
	//----
	//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
	/*
	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	//int DoModalEx(HWND hWndParent = NULL)	
	int DoModalEx(HWND hWndParent = NULL, string& strTempFile = "", LPCSTR lpcszDefault = "", bool bShowPlotButton = false, int nPageType = EXIST_NONE)
	{
		m_strCurrentTemp = lpcszDefault;
		m_strCurrentTemp = m_strCurrentTemp.GetToken(0,'.');
		m_bPlot = bShowPlotButton;
		m_nTemplateType = nPageType;
		
		InitMsgMap();// will be called from internal later
		
		DWORD dwDlgOptions = 0;
		int nRet = ResizeDialog::DoModal(hWndParent, dwDlgOptions);
		
		strTempFile = m_strCurrentTemp;
		///End GET_TEMPLATE_BOX
		
		if(nRet != IDCANCEL)
		{
		}
		return nRet;
	}
	*/
	/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	//	int DoModalEx(HWND hWndParent, string& strTempFile, LPCSTR lpcszDefault = NULL, bool bShowPlotButton = false, int nPageType = EXIST_NONE, int* pnOpenPlotSetupPlotType = NULL);
	int DoModalEx(HWND hWndParent, string& strTempFile, LPCSTR lpcszDefault = NULL, bool bShowPlotButton = false, int nPageType = EXIST_NONE, int* pnOpenPlotSetupPlotType = NULL, BOOL bTemplateBrowser = FALSE);
	/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	//-----
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)	///Jasmine 09/27/05 SPLITTER_INIT_SIZE_ON_READY
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_OK(OnOK)
	ON_CANCEL(OnClose)

	ON_BN_CLICKED(IDC_TP_NEW, OnClickNew)
	ON_BN_CLICKED(IDC_TP_DELETE, OnClickDelete)
	ON_BN_CLICKED(IDC_TP_ADD, OnClickAdd)
	ON_BN_CLICKED(IDC_TP_PLOTSETUP, OnClickPlotSetup)///Jasmine 12/19/05 MODIFICATION_ON_BUTTONS
	///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	ON_BN_CLICKED(IDC_TP_SCAN_USER_TEMPLATES, OnClickScanUsreTemplates)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	ON_RESTORESIZE(OnRestoreSize)
	///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	ON_USER_MSG(WM_USER_BTNS_STATUS, OnSelChange)	///Jasmine 
EVENTS_END

	BOOL OnInitDialog();
	BOOL OnReady();	///Jasmine 09/27/05 SPLITTER_INIT_SIZE_ON_READY
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnDestroy();
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);
	
	BOOL OnOK();
	BOOL OnClose();
	
	BOOL OnClickNew(Control ctrl);
	BOOL OnClickDelete(Control ctrl);
	BOOL OnClickAdd(Control ctrl);
	BOOL OnClickPlotSetup(Control ctrl);///Jasmine 12/19/05 MODIFICATION_ON_BUTTONS
	///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	BOOL OnClickScanUsreTemplates(Control ctrl);
	int GetTotalWidth(bool bMin = false);
	int GetTotalHeight(bool bMin = false);
	BOOL OnRestoreSize(DWORD dwSizeInfo);
	///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
public:
	BOOL OnSelChange(uint wParam, uint lParam);///Jasmine
	//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
private:

	///Kyle 04/08/2009 QA80-13299 TO_GET_DIALOG_MIN_SIZE_BY_SIZE_OF_BUTTONS
	int getDlgMinWidth();
	///End TO_GET_DIALOG_MIN_SIZE_BY_SIZE_OF_BUTTONS

	bool checkOpenPlotSetup(bool bCheckActiveWksSel, bool bDelayedOpen, int nPlotID = IDM_PLOT_UNKNOWN);
	int	m_nDelayedOpenPlotSetupPlotType;
	//	bool					m_bPlot;	
	bool	m_bPlotSetup;//there is PlotSetup button and OK button, when page type is set to EXIST_PLOT, then OK button is the Plot button, OK button is actually "Plot" in rc
	bool	m_bCloseFromPlotSetupButton;// when making plot, we support both Plot button and PlotSetup button, so this will indicate that a close is resulted from a PlotSetup button
public:
	BOOL LanchPlotSetupDlg(int nPlotID, HWND hWndParent);
	//-----
	BOOL NewWindow(int nTemplateType, LPCSTR lpcszTemplate);	///Jasmine 09/11/07 ADD_NEW_WINDOW_FOR_WKS_AND_MATRIX
private:
	//---- CPY 10/5/05 CLASS_FORWARD_DECLARATION_MUST_USE_PTR
	//TPSplitter			m_splitter;
	TPSplitter*				m_psplitter;
	//----
	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	string 					m_strCurrentTemp;
	int						m_nTemplateType;
	///End GET_TEMPLATE_BOX
	int 					m_nCurrentSelRow;///Jasmine 12/28/05 REMEMBER_LAST_SELECTION
	
	/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	BOOL					m_bTemplateBrowser;
	/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
};
///end

///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
static int _get_template_type_from_ext(LPCSTR lpcszExt)
{
	string strExt(lpcszExt);
	if(strExt.Left(1) == ".")
		strExt = strExt.GetToken(1, '.');
	if(!strExt.CompareNoCase("otp"))
		return TP_TYPE_GRAPH;
	if(!strExt.CompareNoCase("otw"))
		return TP_TYPE_WORKBOOK;
	if(!strExt.CompareNoCase("otm"))
		return TP_TYPE_MATRIX;
	return TP_TYPE_UNDEFINED;
}
///End RESTORE_DEL_TEMPLATE
BOOL TemplateOrganizerDlg::OnInitDialog()
{
	PROFILE_HRGLASS
	ResizeDialog::OnInitDialog();
	///Jasmine 12/26/05 MODIFICATION_ON_BUTTONS
	//OnButtonStatus(0, 0);//disable buttons
	OnSelChange(0, 1);//Hong 7/27/06 ADD_FILEPATH_AND_DATEMODIFY
	//m_psplitter->Init(IDC_TP_BOX, *this, STR_DLG_NAME);	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	if(m_strCurrentTemp.IsEmpty())
		m_nCurrentSelRow = LoadSetting("CurrentSelRow", -1, STR_DLG_NAME);
	m_psplitter->Init(IDC_TP_BOX, *this, STR_DLG_NAME, true, m_strCurrentTemp, m_nTemplateType, m_nCurrentSelRow);
	///jasmine 11/28/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	//button's Visibility depends on m_nTemplateType and m_bPlotSetup
	Button btnPlot=GetItem(IDOK);
	Button btnPlotSetup=GetItem(IDC_TP_PLOTSETUP);
	//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
	//btnPlot.Text = "Ok";
	//btnPlot.Visible = true;		
	//btnPlotSetup.Visible = false;
	//if(!m_nTemplateType)
	//	return true;
	btnPlotSetup.Visible = m_bPlotSetup;
	//-----
///Jasmine 09/11/07 COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER	
	Text = STR_DLG_NAME;
#ifdef COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
	uint nButtonIDs[] = {IDC_TP_NEW, IDC_TP_ADD, IDC_TP_DELETE};
	for(int ii = 0; ii < 3; ii++)
	{
		Button btn = GetItem(nButtonIDs[ii]);
		btn.Visible = false;
	}
#endif//COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
	/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	if( m_bTemplateBrowser )
	{
		uint nButtonIDs[] = {IDC_TP_NEW, IDC_TP_ADD, IDC_TP_DELETE};
		for(int ii = 0; ii < 3; ii++)
		{
			Button btn = GetItem(nButtonIDs[ii]);
			btn.Visible = false;
		}
		btnPlot.Visible = true;
		btnPlot.Text = _L("Ok");
		GetWindow().Text = _L("Template Browser");
	}
	else
	/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	{
#ifndef COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
		//------ Folger 01/23/08 QA70-10980 ADD_NEW_TEMPLATE_AND_NEW_CATEGORY_BUTTON
		//if(EXIST_PLOT == m_nTemplateType)
		//{
			////btnPlotSetup.Enable = m_bPlotSetup;
			////----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
			////btnPlot.Text = m_bPlotSetup? "Plot" : "Ok";
			////btnPlotSetup.Visible = m_bPlotSetup;
			//uint nButtonIDs[] = {IDC_TP_NEW, IDC_TP_ADD, IDC_TP_DELETE};
			//for(int ii = 0; ii < 3; ii++)
			//{
				//Button btn = GetItem(nButtonIDs[ii]);
				//btn.Visible = false;
			//}	
			////-----
			////if(m_bPlotSetup)
				////btnPlot.Enable = false;//will further check selection and enable "Plot" button 
										////only if there is valid selection
		//}
		////----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
		//else
		//{
			//btnPlot.Visible = false;
			//// Cancel button must be changed to Close button if not making plots
			//Button btnCancel = GetItem(IDCANCEL);
			//btnCancel.Text = _L("Close");
		//}
		GetItem(IDC_TP_DELETE).Visible = false;
		//------
#else
		GetItem(IDCANCEL).Text = _L("Close");
#endif//COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
///End COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER	
	}
	//-----
	
	//not support Workbook and Matrix
	//else
	//{
		//btnPlot.Text = "Export";
		//btnPlotSetup.Enable = false;
		//btnPlotSetup.Visible = false;
	//}	
	///End MODIFICATION_ON_BUTTONS
	///End GET_TEMPLATE_BOX
	//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
	m_nDelayedOpenPlotSetupPlotType = 0;
	m_bCloseFromPlotSetupButton = false;
	///Hong 7/27/06 ADD_FILEPATH_AND_DATEMODIFY
	string strFileName = m_psplitter->GetSel(m_nCurrentSelRow);
	string strFileDate = GetFileModificationDate((LPCSTR)strFileName, LDF_SHORT_AND_HHMMSS_SEPARCOLON);
	/// Max 07-11-07 CORRCT_LOCALIZATION
	//GetItem(IDC_TP_LOCATION_TEXT).Text = "Location: " + strFileName;
	//GetItem(IDC_TP_DATEMODIFY_TEXT).Text = "Date Modified: " + strFileDate;
	GetItem(IDC_TP_LOCATION_TEXT).Text = _L("Location:") + strFileName;
	GetItem(IDC_TP_DATEMODIFY_TEXT).Text = _L("Date Modified:") + strFileDate;
	/// END CORRCT_LOCALIZATION
	///end ADD_FILEPATH_AND_DATEMODIFY
	//----
	
	///Jasmine 08/10/06 LOAD_DESCRIPTION		
	string strDescription;
	if( !strFileName.IsEmpty() )
		okutil_get_Origin_file_comment(strFileName, &strDescription); 
	//------ Folger 01/22/08 SHOULD_NOT_RENAME_CATEGORY_WITH_SYSTEM_OR_GROUP_TEMPLATE
	if ( strDescription.IsEmpty() )
		strDescription = m_psplitter->GetCategoryDescription();
	//------
	GetItem(IDC_TP_DESCRIPTION_ED).Text = strDescription;
	///End LOAD_DESCRIPTION
		
	///Hong 7/31/06 FIX_TEMPLATE_LIBRARY_TITLE
	/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	//	if(m_nTemplateType == EXIST_PLOT)
	if(m_nTemplateType == EXIST_PLOT && !m_bTemplateBrowser )
	/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
		GetWindow().Text = _L("Template Library");
	///end FIX_TEMPLATE_LIBRARY_TITLE
	return true;
}
///Jasmine 09/27/05 SPLITTER_INIT_SIZE_ON_READY
BOOL TemplateOrganizerDlg::OnReady()
{			
	SetInitReady();
	m_psplitter->OnReady();
	
	return true;
}
///End SPLITTER_INIT_SIZE_ON_READY
BOOL TemplateOrganizerDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return false;
	MoveControlsHelper	_temp(this);		///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
	//uint nButtonIDs[] = {IDOK, IDCANCEL, IDC_TP_NEW, IDC_TP_ADD, IDC_TP_DELETE, 0};	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	//uint nButtonIDs[] = {IDCANCEL, IDOK, IDC_TP_DELETE, IDC_TP_ADD, IDC_TP_NEW, 0};
	uint nButtonIDs[] = {IDCANCEL, IDOK, IDC_TP_DELETE, IDC_TP_ADD, IDC_TP_NEW, IDC_TP_SCAN_USER_TEMPLATES, 0};
	///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	///Hong 7/27/06 ADD_FILEPATH_AND_DATEMODIFY
	//uint nCtrlIDs[]={IDC_TP_DESCRIPTION_TEXT, IDC_TP_DESCRIPTION_ED, 0};
	uint nCtrlIDs[]={IDC_TP_DESCRIPTION_TEXT, IDC_TP_DESCRIPTION_ED, IDC_TP_LOCATION_TEXT, IDC_TP_DATEMODIFY_TEXT, 0};
	///end ADD_FILEPATH_AND_DATEMODIFY
	RECT rr;
	int nEdge = GetControlGap();
	Button btnOK;
	GetControlClientRect(IDOK, rr, &btnOK);
	int nBtnHeight = RECT_HEIGHT(rr);
	
	cy-=(nBtnHeight+nEdge);
	ArrangeControlsRightLeft(nButtonIDs, cx, cy);
	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	Control ctrl;
	GetControlClientRect(IDC_TP_PLOTSETUP, rr, &ctrl);
	rr.left = nEdge;
	rr.top = cy;
	rr.bottom = rr.top+nBtnHeight;
	MoveControl(ctrl, rr);
	///End GET_TEMPLATE_BOX
	StretchControlWide(IDC_TP_DESCRIPTION_ED, nEdge, nEdge, cx, nEdge);
	StretchControlWide(IDC_TP_LOCATION_TEXT, nEdge, nEdge, cx, nEdge);//Hong 7/27/06 ADD_FILEPATH_AND_DATEMODIFY
	StretchControlWide(IDC_TP_DATEMODIFY_TEXT, nEdge, nEdge, cx, nEdge);//Hong 7/27/06 ADD_FILEPATH_AND_DATEMODIFY
	int nWidth, nHeight;
	GetGroupTotalSize(nCtrlIDs, nWidth, nHeight, false, nEdge);
	cy-=(nHeight+nEdge);
	ArrangeControlsTopDown(nCtrlIDs, nEdge, cy);
	
	Control cc;
	GetControlClientRect(IDC_TP_BOX, rr, &cc);
	rr.right = cx-nEdge;
	rr.bottom = cy-nEdge;	//cy-nBtnHeight-2*nEdge;
	MoveControl(cc, rr);
	m_psplitter->OnDlgResize(nType, cx, cy);	///Jasmine 03/16/06 FORCE_TO_CALL_RESIZE
	return true;
}
BOOL TemplateOrganizerDlg::OnDestroy()
{
	SaveSetting("CurrentSelRow", m_nCurrentSelRow, STR_DLG_NAME);///Jasmine 12/28/05 REMEMBER_LAST_SELECTION
	return true;
}
BOOL TemplateOrganizerDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	return FALSE;
}
BOOL TemplateOrganizerDlg::OnOK()
{
	m_strCurrentTemp = m_psplitter->GetSel(m_nCurrentSelRow);	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX	///Jasmine 12/28/05 REMEMBER_LAST_SELECTION
	//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
	/*
	///Jasmine 12/19/05 MODIFICATION_ON_BUTTONS
	string strTitle = "OK";
	if(EXIST_PLOT == m_nTemplateType)
		strTitle = "Plot : Not Support";
	if(m_strCurrentTemp.IsEmpty())
		return false;
	MessageBox(NULL, "Selected Template : \n"+ m_strCurrentTemp, strTitle, MB_ICONINFORMATION);
	*/
	///End
	//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
	checkOpenPlotSetup(true, true);
	//-----
	return true;
}
BOOL TemplateOrganizerDlg::OnClose()
{
	m_psplitter->GetSel(m_nCurrentSelRow);///Jasmine 12/28/05 REMEMBER_LAST_SELECTION
	return true;
}
BOOL TemplateOrganizerDlg::OnClickNew(Control ctrl)
{
	m_psplitter->NewCategory();
	
	return true;
}
BOOL TemplateOrganizerDlg::OnClickDelete(Control ctrl)
{
	m_psplitter->DelCateOrTemp();
	return true;
}
BOOL TemplateOrganizerDlg::OnClickAdd(Control ctrl)
{
	m_psplitter->AddTemplate();
	
	return true;
}
//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
// assume m_strCurrentTemp before this function is called
bool TemplateOrganizerDlg::checkOpenPlotSetup(bool bCheckActiveWksSel, bool bDelayedOpen, int nPlotType)// = true);
{
	m_nDelayedOpenPlotSetupPlotType = bDelayedOpen? nPlotType : 0;
	if(m_nDelayedOpenPlotSetupPlotType)
		return true;
	
	return LanchPlotSetupDlg(nPlotType, GetSafeHwnd());
}
BOOL TemplateOrganizerDlg::LanchPlotSetupDlg(int nPlotType, HWND hWndParent)
{
	FUNC_BOOL_INT_STR_HWND pfn = Project.FindFunction("PlotSetup");
	if( pfn )
		return pfn(TRUE, nPlotType, m_strCurrentTemp, hWndParent);

	out_str("TemplateOrganizerDlg failed to compile PlotSetup"); 
	return false;
}
///Jasmine 09/11/07 ADD_NEW_WINDOW_FOR_WKS_AND_MATRIX
BOOL TemplateOrganizerDlg::NewWindow(int nTemplateType, LPCSTR lpcszTemplate)
{
	switch(nTemplateType)
	{
	case TP_TYPE_WORKBOOK:
		WorksheetPage wp;
		return wp.Create(lpcszTemplate);
	case TP_TYPE_GRAPH:
		GraphPage gp;
		/// Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
		//return gp.Create(lpcszTemplate);
		return gp.Create(lpcszTemplate, CREATE_DEFAULT_OPTIONS | CREATE_ENUM_EXIST_PAGE);
		/// End QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
	case TP_TYPE_MATRIX:		
		MatrixPage mp;
		return mp.Create(lpcszTemplate);
	}
	return FALSE;
}
///End ADD_NEW_WINDOW_FOR_WKS_AND_MATRIX

/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
//	int TemplateOrganizerDlg::DoModalEx(HWND hWndParent, string& strTempFile, LPCSTR lpcszDefault, bool bShowPlotSetupButton, int nPageType, int* pnOpenPlotSetupPlotType)
int TemplateOrganizerDlg::DoModalEx(HWND hWndParent, string& strTempFile, LPCSTR lpcszDefault, bool bShowPlotSetupButton, int nPageType, int* pnOpenPlotSetupPlotType, BOOL bTemplateBrowser)
/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
{
	m_strCurrentTemp = lpcszDefault;
	m_strCurrentTemp = m_strCurrentTemp.GetToken(0,'.');
	m_bPlotSetup = bShowPlotSetupButton;
	m_nTemplateType = nPageType;

	/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	m_bTemplateBrowser = bTemplateBrowser;
	/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL

	InitMsgMap();// will be called from internal later
	
	DWORD dwDlgOptions = 0;
	int nRet = ResizeDialog::DoModal(hWndParent, dwDlgOptions);
	
	strTempFile = m_strCurrentTemp;
	
	if(nRet == IDCANCEL)
	{
		if(m_bCloseFromPlotSetupButton)
			nRet = IDRETRY;// can be anything other hand IDOK and IDCANCEL
		else
			return IDCANCEL;
	}

	if(pnOpenPlotSetupPlotType)
		*pnOpenPlotSetupPlotType = m_nDelayedOpenPlotSetupPlotType;

//	LanchPlotSetupDlg(m_nDelayedOpenPlotSetupPlotType, GetWindow(OGW_MAIN));
	
	return nRet;
}
//----- end CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER

///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
BOOL TemplateOrganizerDlg::OnClickScanUsreTemplates(Control ctrl)
{
	m_psplitter->ScanUserTemplates();
	return true;
}

int TemplateOrganizerDlg::GetTotalHeight(bool bMin)
{
	return MIN_MAIN_DLG_HEIGHT;
}

int TemplateOrganizerDlg::GetTotalWidth(bool bMin)
{
	///Kyle 04/08/2009 QA80-13299 TO_GET_DIALOG_MIN_SIZE_BY_SIZE_OF_BUTTONS
	//return MIN_MAIN_DLG_WIDTH;
	if(bMin)
	{
		int nMinWidth = getDlgMinWidth();
		return nMinWidth > MIN_MAIN_DLG_WIDTH ? nMinWidth : MIN_MAIN_DLG_WIDTH;
	}
	else
	{
		return ResizeDialog::GetTotalWidth(bMin);
	}
	///End TO_GET_DIALOG_MIN_SIZE_BY_SIZE_OF_BUTTONS
}

///Kyle 04/08/2009 QA80-13299 TO_GET_DIALOG_MIN_SIZE_BY_SIZE_OF_BUTTONS
int TemplateOrganizerDlg::getDlgMinWidth()
{
	int nMinWidth = 0;

	vector<int> vnButtonIDs = {IDCANCEL, IDOK, IDC_TP_DELETE, IDC_TP_ADD, IDC_TP_NEW, IDC_TP_SCAN_USER_TEMPLATES, IDC_TP_PLOTSETUP};
	for(int ii = vnButtonIDs.GetSize()-1; ii >= 0; ii--)
	{
		RECT rr;
		Button btn;
		GetControlClientRect(vnButtonIDs[ii], rr, &btn);
		if(!btn)
			return MIN_MAIN_DLG_WIDTH;
		nMinWidth += RECT_WIDTH(rr);
	}
	nMinWidth += vnButtonIDs.GetSize()*GetControlGap();

	return nMinWidth;
}
///End TO_GET_DIALOG_MIN_SIZE_BY_SIZE_OF_BUTTONS


BOOL TemplateOrganizerDlg::OnRestoreSize(DWORD dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);

	pSz->top = -1;
	pSz->left = -1;
	///Kyle 04/08/2009 QA80-13299 TO_GET_DIALOG_MIN_SIZE_BY_SIZE_OF_BUTTONS
	//pSz->width = 600;
	int nMinWidth = getDlgMinWidth();
	pSz->width = nMinWidth > 600 ? nMinWidth : 600;
	///End TO_GET_DIALOG_MIN_SIZE_BY_SIZE_OF_BUTTONS
	pSz->height = 500;
	
	return TRUE;
}
///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER

///Jasmine 12/19/05 MODIFICATION_ON_BUTTONS
BOOL TemplateOrganizerDlg::OnClickPlotSetup(Control ctrl)
{
	m_strCurrentTemp = m_psplitter->GetSel(m_nCurrentSelRow);///Jasmine 12/28/05 REMEMBER_LAST_SELECTION
	//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
	// code moved inside openPlotSetup
///Jasmine 09/11/07 COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER	
#ifndef COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER	
	if(EXIST_PLOT == m_nTemplateType)
	{
		PostMessage(WM_CLOSE);
		m_bCloseFromPlotSetupButton = true;
		return checkOpenPlotSetup(true, true);
	}
	else
#endif//COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
	///Jasmine 09/11/07 ADD_NEW_WINDOW_FOR_WKS_AND_MATRIX
	{
		string strExt;
		separate_file_name_ext(m_strCurrentTemp, NULL, &strExt);
		int nTemplateType = _get_template_type_from_ext(strExt); 
		if(TP_TYPE_GRAPH == nTemplateType)
		//------ Folger 09/30/07 QA70-10464 CLOSE_ORGANIZER_AFTER_PLOT_SETUP_SUCCESSFULLY
			//return checkOpenPlotSetup(false, false);
		//return NewWindow(nTemplateType, m_strCurrentTemp);
		{
			///Jasmine 10/22/09 QA81-14470-P3 RX_THETAY_POLAR_GRAPH_NEED_PLOT_ID_FROM_STYLE_HOLDER
			//if (checkOpenPlotSetup(false, false))
			int nPlotType; 
			if( !_get_special_plot_id(m_strCurrentTemp, nPlotType) )
				nPlotType = IDM_PLOT_UNKNOWN;
			if( checkOpenPlotSetup(false, false, nPlotType) )
			///End RX_THETAY_POLAR_GRAPH_NEED_PLOT_ID_FROM_STYLE_HOLDER
			{
				PostMessage(WM_CLOSE);
				return true;
			}
			return false;
		}
		if (NewWindow(nTemplateType, m_strCurrentTemp))
		{
			PostMessage(WM_CLOSE);
			return true;
		}
		return false;
		//------ End CLOSE_ORGANIZER_AFTER_PLOT_SETUP_SUCCESSFULLY
	}
	///End ADD_NEW_WINDOW_FOR_WKS_AND_MATRIX
	//-----
}
///Jasmine 12/26/05 CHANGE_BTN_STATUS
BOOL TemplateOrganizerDlg::OnSelChange(uint wParam, uint lParam)
{	
	int nLevel = wParam;
	uint nButtonIDs[] = {IDC_TP_NEW, IDC_TP_ADD, IDC_TP_DELETE, IDOK};//, IDC_TP_PLOTSETUP};//no need to disable Plot Setup button...
	/*
	TP_BTN_NEW = 0,
	TP_BTN_ADD,
	TP_BTN_DELETE,
	TP_BTN_OK,
	TP_BTN_PLOTSETUP,
	
	TP_BTN_CANCEL
	*/
	///Hong 7/27/06 ADD_FILEPATH_AND_DATEMODIFY
	//------ Folger 09/06/07 MORE_CONTROL_OF_BUTTONS_STATUS
	//BOOL bInit = lParam;
	bool bInit = lParam & SEL_CHANGE_INIT;
	bool bUser = lParam & SEL_CHANGE_USER_FLAG;
	//------ End MORE_CONTROL_OF_BUTTONS_STATUS
	if(!bInit)
	{
		string strFileName = m_psplitter->GetSel(m_nCurrentSelRow);
		string strFileDate = GetFileModificationDate(strFileName, LDF_SHORT_AND_HHMMSS_SEPARCOLON);
		
		/// Max 07-11-07 COREECT_LOCALIZATION
		//GetItem(IDC_TP_LOCATION_TEXT).Text = "Location: " + strFileName;
		//GetItem(IDC_TP_DATEMODIFY_TEXT).Text = "Date Modified: " + strFileDate;
		GetItem(IDC_TP_LOCATION_TEXT).Text = _L("Location:") + strFileName;
		GetItem(IDC_TP_DATEMODIFY_TEXT).Text = _L("Date Modified:") + strFileDate;
		/// END COREECT_LOCALIZATION
		///Jasmine 08/10/06 LOAD_DESCRIPTION
		string strDescription;
		int	nRet = okutil_get_Origin_file_comment(strFileName, &strDescription);
		//------ Folger 01/22/08 SHOULD_NOT_RENAME_CATEGORY_WITH_SYSTEM_OR_GROUP_TEMPLATE
		if ( strDescription.IsEmpty() )
			strDescription = m_psplitter->GetCategoryDescription();
		//------
		GetItem(IDC_TP_DESCRIPTION_ED).Text = strDescription;
		///End LOAD_DESCRIPTION
	}
	///end ADD_FILEPATH_AND_DATEMODIFY
	///Jasmine 09/11/07 ADD_NEW_WINDOW_FOR_WKS_AND_MATRIX
	///Jasmine 09/30/06 DISABLE_PLOTSETUP_BTN_IF_NOT_GRAPH_TEMPLATE
	bool bCanPlot = !(nLevel < 0);	///Jasmine 09/11/07 COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
	GetItem(IDC_TP_PLOTSETUP).Text = bCanPlot? _L("Plot Setup...") : _L("New Window");	
	nLevel = abs(nLevel);
	///End DISABLE_PLOTSETUP_BTN_IF_NOT_GRAPH_TEMPLATE
	///End ADD_NEW_WINDOW_FOR_WKS_AND_MATRIX
	GetItem(IDC_TP_PLOTSETUP).Enable = nLevel == TR_LEVEL_TEMPLATE;
	Button btn;
	for(int ii = 0; ii<TP_BTN_PLOTSETUP; ii++)
	{
		btn = GetItem(nButtonIDs[ii]);
		btn.Enable = false;
	}
	switch(nLevel)
	{
	case TR_LEVEL_BRANCH:
		btn = GetItem(IDC_TP_NEW);	btn.Enable = true;
		break;
	case TR_LEVEL_CATEGORY:
		btn = GetItem(IDC_TP_NEW);	btn.Enable = true;
		btn = GetItem(IDC_TP_ADD);	btn.Enable = true;
		btn = GetItem(IDC_TP_DELETE);	btn.Enable = true;
		break;
	case TR_LEVEL_TEMPLATE:
		btn = GetItem(IDC_TP_ADD);	btn.Enable = true;
		//------ Folger 09/06/07 MORE_CONTROL_OF_BUTTONS_STATUS
		//btn = GetItem(IDC_TP_DELETE);	btn.Enable = true;
		btn = GetItem(IDC_TP_DELETE);	btn.Enable = bUser;
		//------ End MORE_CONTROL_OF_BUTTONS_STATUS
		btn = GetItem(IDOK);			btn.Enable = bCanPlot;//true
		//btn = GetItem(IDC_TP_PLOTSETUP);	btn.Enable = true;
		break;
	default: break;
	}
	return true;
}
//End CHANGE_BTN_STATUS



///Jasmine 12/05/27 CALLED_BY_FINDFUNCTION
BOOL GetTemplateBox(string& strFullPath, LPCSTR lpcszDefault, bool bShowPlotButton, int nPageType, HWND hParent)
{	
	TemplateOrganizerDlg	TODlg();
	Window winDlg(hParent);
	HWND hWnd = GetWindow();
	if(winDlg)
		hWnd = hParent;

	int nRet = TODlg.DoModalEx( hWnd, strFullPath, lpcszDefault, bShowPlotButton, nPageType);
	bool flag = (nRet != IDCANCEL);
	return flag;
}
/*
void get_templatebox()
{
	string strFilePath;
	string strPath;
	strPath.Format("%sOriginC\\OriginLab\\TemplateOrganizer.c", GetAppPath(TRUE));
	FUNC_STR_STR_BOOL_INT_HWND pfn = Project.FindFunction("GetTemplateBox", strPath);
	if( pfn )
	{
		if(pfn(strFilePath, "Bar", true, EXIST_PLOT, GetWindow()))
			printf("Selected Template name : %s\n", strFilePath);
	}
}
*/
///End CALLED_BY_FINDFUNCTION
///End GET_TEMPLATE_BOX



/////////////////////////////////////////////////////////////////////////////
//////////////////////////////	TPSplitter		/////////////////////////////
/////////////////////////////////////////////////////////////////////////////


BOOL TPSplitter::OnInitSplitter()
{
	m_bReady = false;
	
	PROFILE_HRGLASS
	
	GUID clsid; // later, for now, only vsFlex
	CreateActiveXPane(clsid, PANE_ROW_COL_LIST);		
	m_tplist.Init(m_IDTreePane, *this);
	
	initOrganizerArray();
	///Jasmine 10/12/06 ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
	//use the same codes with template_saveas
	/*
	///Jasmine 02/05/06 TEMPLATE_INFO_INTERNAL_ACCESS_NAME_CHANGE
	//if(!m_arrTP.GetAt(TP_TYPE_GRAPH).GetTemplateListFile(m_trTP))
	if(!m_arrTP.GetAt(0).GetTemplateListFile(m_trTP))
	{
		for(int ii=0; ii<m_arrTP.GetSize(); ii++)
		{
			TemplateOrganizer &tp=m_arrTP.GetAt(ii);
			tp.ConstructSubTree(m_trTP);
		}
		GETN_USE(m_trTP)
		GETN_BEGIN_BRANCH(branchDelete, STR_DELETE_SECTION)
		//GETN_CURRENT_SUBNODE.DataID=TP_TYPE_MATRIX;
		GETN_END_BRANCH(branchDelete)
	}
	///Jasmine 12/19/05 COMPARE_INI_MODIFICATION_TIME_WITH_XML
	else
		if(is_ini_file_newer())//ini is newer
			///Jasmine 02/05/06 TEMPLATE_INFO_INTERNAL_ACCESS_NAME_CHANGE
			//m_arrTP.GetAt(TP_TYPE_GRAPH).ConstructSubTree(m_trTP);
			///Jasmine 07/25/06 ADD_DEFAULT_ORG_IN_ARRAY
			m_arrTP.GetAt(1).ConstructSubTree(m_trTP);	//m_arrTP.GetAt(0).ConstructSubTree(m_trTP);
	*/
	if(!m_arrTP.GetAt(0).GetTemplateListFile(m_trTP))
		return error_report("fail to load Template.xml!");
	///End ADD_WORKBOOK_TEMPLATE_INTO_TEMPLATE_INI
	m_tplist.ShowTemplateList(m_trTP, m_nShowType);
	
//---- Kevin
	CreatePane(m_picCtrl, PANE_ROW_COL_PAGE);
	m_picCtrl.KeepAspectRatio = true;
///Jasmine 08/09/06 LOOK_FOR_EMF_FIRST
//----
	m_nSelRow = -1;
	SetReady();
	m_bReady = true;
	
	return TRUE;
}
BOOL TPSplitter::OnDestroy()
{
	//------ Folger 08/22/07 COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML
	//m_trTP.Save(STR_TEMPLATE_FILE);
	octree_delete_nodes_by_missing_attribute(&m_trTP, STR_USER_PATH_ATTRIB);
	//------ Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
	octree_remove_attribute(&m_trTP, STR_FILENAME_ATTRIB);
	_remove_template_label_attribue(m_trTP);
	//------ End NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
	m_trTP.Save(STR_TEMPLATE_XML);	
	//------ End COMBINE_SYSTEM_USER_GROUP_TEMPLATE_XML
	//m_trTP.Save(STR_GROUP_TEMPLATE_XML);	///Jasmine 07/30/07 #8854 SHOW_TEMPLATE_UNDER_GROUP_FOLDER	///Jasmine 08/15/07 #10155 NO_MODIFICATION_TO_GROUP_FOLDER_FILE
	SplitterControl::OnDestroy();
	return true;
}
BOOL TPSplitter::OnResize(int nType, int cx, int cy)
{
	SplitterControl::OnResize(nType, cx, cy);
	return true;
}
void TPSplitter::OnRowChange(Control ctrl)
{	
	if(!m_bReady)
		return;
	
	PROFILE_HRGLASS
	
	int nNewSel = m_tplist.GetSelectedRow();
	if(m_nSelRow == nNewSel)
		return;
	
	TreeNode trOldNode=GetTreeNode(m_nSelRow), trNewNode=GetTreeNode(nNewSel);
	m_nSelRow = nNewSel;
	///Jasmine 12/26/05 CHANGE_BTN_STATUS
	//if(inDelSection(m_nSelRow))
		//return;
	///Jasmine 09/30/06 DISABLE_PLOTSETUP_BTN_IF_NOT_GRAPH_TEMPLATE
	TemplateOrganizer& tpOld=GetCurrentOrganizer();
	TemplateOrganizer& tpNew=GetCurrentOrganizer(m_nSelRow, true);
	uint nLevel;
	nLevel = (inDelSection(m_nSelRow))? 0 : tree_get_level(trNewNode);
	if(/*TR_LEVEL_TEMPLATE == nLevel &&*/ tpNew.GetTemplateExt().CompareNoCase("otp"))	///Jasmine 09/11/07 ADD_NEW_WINDOW_FOR_WKS_AND_MATRIX
		nLevel *= -1;
	//------ Folger 09/06/07 MORE_CONTROL_OF_BUTTONS_STATUS
	int nUserFlag = 0;
	trNewNode.GetAttribute(STR_USER_PATH_ATTRIB, nUserFlag);
	//------ End MORE_CONTROL_OF_BUTTONS_STATUS
	Window Wnd = GetParent();
	if(Wnd)
		//------ Folger 09/06/07 MORE_CONTROL_OF_BUTTONS_STATUS
		//Wnd.SendMessage(WM_USER_BTNS_STATUS, nLevel, 0);
		Wnd.SendMessage(WM_USER_BTNS_STATUS, nLevel, nUserFlag ? SEL_CHANGE_USER_FLAG : 0);
		//------ End MORE_CONTROL_OF_BUTTONS_STATUS
		
	///End CHANGE_BTN_STATUS
	///Jasmine 02/06/06 BLOCK_IN_DEL_SECTION
	if(!nLevel)
	{
		///Kyle 03/23/2009 QA80-13299 FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
		//m_picCtrl.Visible = true;
		//m_picCtrl.Visible = false;
		m_picCtrl.SetBitMap(NULL);
		///End FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
		return;
	}
	///End BLOCK_IN_DEL_SECTION
	///End DISABLE_PLOTSETUP_BTN_IF_NOT_GRAPH_TEMPLATE
//---- Kevin
	/*if(!tpNew.IsTemplateNode(trNewNode))
	{
		Control& cOldPage = tpOld.GetCtrl();
		if(cOldPage && cOldPage.Visible)	//ignore the dialog refresh when nothing is shown
		{
			Visible = false;	//hide then show to force refreshing
			if(cOldPage)
				cOldPage.Visible = false;
			Visible = true;
		}
	}
	else
	{
		Control& cNewPage = tpNew.GetCtrl();
		if(tpOld.GetTemplateType() != tpNew.GetTemplateType() || !cNewPage)
			CreatePageControl(tpOld, tpNew);
		
		cNewPage.Visible = false;
		tpNew.LoadTemplate(tpNew.GetLabel(trNewNode));
		cNewPage.Visible = true;
	}*/
	///Jasmine 11/22/05 QA70-8347 v8.0339 GET_TEMPLATE_BOX
	/*
	if(!m_nShowType)
	{
		Window Wnd = GetParent();
		if(Wnd)
			Wnd.SendMessage(WM_USER_BTNS_STATUS);//, tpNew.GetTemplateType()? false : true);
	}
	*/
	///End GET_TEMPLATE_BOX
	if ( tpNew.IsTemplateNode(trNewNode) ) 
	{
		///Kyle 03/23/2009 QA80-13299 FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
		//m_picCtrl.Visible = false;
		///End FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
		///Jasmine 11/24/05 v8.0339 TEMPLATE_HAS_NO_PICTURE
		//how to force it update when .Visible = false ?
		//tpNew.LoadTemplate(tpNew.GetLabel(trNewNode), m_picCtrl);
		///Hong 7/28/06 FIX_USER_CUSTOM_NO_PREVIEW
		//if(	!tpNew.LoadTemplate(tpNew.GetLabel(trNewNode), m_picCtrl) )
		//TreeNode trSelNode=GetTreeNode(m_nSelRow);
		string strPath;
		bool flag = trNewNode.GetAttribute(STR_FILENAME_ATTRIB, strPath);
		if(!tpNew.LoadTemplate(strPath, m_picCtrl) )
		///end FIX_USER_CUSTOM_NO_PREVIEW
		{
			///Kyle 03/23/2009 QA80-13299 FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
			//m_picCtrl.Visible = true;
			//m_picCtrl.Visible = false;
			m_picCtrl.SetBitMap(NULL);
			///End FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
			return;
		}///End TEMPLATE_HAS_NO_PICTURE
		///Kyle 03/23/2009 QA80-13299 FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
		//m_picCtrl.Visible = true;
		///End FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
	}
	else
	{
		///Kyle 03/23/2009 QA80-13299 FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
		//m_picCtrl.Visible = true;
		//m_picCtrl.Visible = false;
		m_picCtrl.SetBitMap(NULL);
		///End FIX_REFRESH_PROBLEM_WHEN_THE_PREVIEW_PICTURE_IS_NOT_VISIBLE
	}
//-----
}
///Jasmine 12/26/05 ADD_CONTEXT_MENU
BOOL TPSplitter::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{ 
///Jasmine 09/11/07 COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER	
#ifdef COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
	if(m_IDTreePane == nResIDCtrl)
#else
	//------ Folger 01/23/08 QA70-10980 ADD_NEW_TEMPLATE_AND_NEW_CATEGORY_BUTTON
	//if(m_IDTreePane == nResIDCtrl && !m_nShowType)//disable context menu if m_nShowType!=0, same as New Category, Add Template, Delete Buttons	
	if(m_IDTreePane == nResIDCtrl)
	//------
#endif
///End COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER	
		return OnCmdWndMenu(nx, ny);	
	return FALSE;
}
BOOL TPSplitter::OnCmdWndMenu(int nx, int ny)
{
	int nClickRow, nClickCol;
	m_tplist.GetMouseCell(nClickRow, nClickCol);
	if(0 <= nClickRow)
		m_tplist.SelRow(nClickRow);
	
	TreeNode trSel = GetTreeNode(nClickRow);
	//int nLevel = tree_get_level(trSel), nCmd;	Jasmine 02/06/06 BLOCK_IN_DEL_SECTION
	int nLevel = (inDelSection(nClickRow))? 0 : tree_get_level(trSel), nCmd;
	
	string strCmd;
	//------ Folger 01/23/08 QA70-10980 MVOE_TEMPLATE_TO_SPECIFIC_CATEGORY
	//TPMenu 	myMenu(nLevel);
	TPMenu 	myMenu(nLevel, isTemplateMoveable(trSel));
	//------
	myMenu.TrackPopupMenu(0,  nx, ny, GetWindow());
	if(myMenu.GetCommand(nCmd))
	{
		switch(nCmd)
		{
		case TP_MENU_NEW_CATEGORY: 
			NewCategory();
			break;
		//case TP_MENU_RENAME:
			//break;
		case TP_MENU_ADD_TEMPLATE:
			AddTemplate();
			break;
		case TP_MENU_DELETE:
			DelCateOrTemp();
			break;
		///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
		case TP_MENU_RESTORE:
			Restore(trSel);
			break;
		///End RESTORE_DEL_TEMPLATE
		//------ Folger 01/23/08 QA70-10980 MVOE_TEMPLATE_TO_SPECIFIC_CATEGORY
		case TP_MENU_MOVE:
			{
				if ( nLevel != TP_LEVEL_TEMPLATE )
					break;
				
				vector<string> vsCategories;
				TreeNode trCategory = trSel.Parent();
				TreeNode trBranch = trCategory.Parent();
				getCategories(vsCategories, trBranch);
				
				string strCategory;
				trCategory.GetAttribute(STR_LABEL_ATTRIB, strCategory);
				string strCombo;
				strCombo.SetTokens(vsCategories, '|');
				
				GETN_TREE(tr)
				GETN_STRLIST(Categories, _L("Move to"), strCategory, strCombo);
				
				if ( GetNBox(tr, _L("Move"), NULL, NULL, NULL, GetSafeHwnd()) )
				{
					string strMoveTo = tr.Categories.strVal;
					if ( strCategory.CompareNoCase(strMoveTo) != 0 )
					{
						TemplateOrganizer& tp=GetCurrentOrganizer(m_nSelRow, false);
						TreeNode trCategoryMoveTo;
						tp.FindCategory(trBranch, strMoveTo, trCategoryMoveTo);
						
						string strFullPath;
						string strBranch;
						trSel.GetAttribute(STR_FILENAME_ATTRIB, strFullPath);
						trBranch.GetAttribute(STR_LABEL_ATTRIB, strBranch);
						
						trSel.Remove();
						m_tplist.DelSection(m_nSelRow);
						
						m_tplist.AddNewToList(tp.AddTemplate(trCategoryMoveTo, strFullPath), m_tplist.GetRow(strMoveTo, m_tplist.GetRow(strBranch)));
					}
				}
			}
			break;
		//------
		default:
			return false;
		}		
		return true;
	}
	return false;
}
///End ADD_CONTEXT_MENU
///Jasmine 12/26/05 DBCLICK_RENAME
void TPSplitter::OnDblClick(Control flxControl)
{
	int nRow = 0, nCol = 0;
	int nx = -1, ny = -1;
	m_tplist.GetSelCell(nx, ny, nRow, nCol);
	if(inDelSection(m_nSelRow))
		return;
	TreeNode trSel = GetTreeNode(nRow);
	int nLevel = tree_get_level(trSel);
	if(TR_LEVEL_CATEGORY == nLevel)
	//------ Folger 01/22/08 SHOULD_NOT_RENAME_CATEGORY_WITH_SYSTEM_OR_GROUP_TEMPLATE
		//m_tplist.SetEditable(flexEDKbdMouse);
	{
		string strName;
		if ( trSel.GetAttribute(STR_NAME_ATTRIB, strName) )
			return;
		string strCategory;
		trSel.GetAttribute(STR_LABEL_ATTRIB, strCategory);
		m_tplist.SetEditable(isCategoryRenameable(strCategory, trSel.Parent().DataID) ? flexEDKbdMouse : flexEDNone);
	}
	//------
}
void TPSplitter::OnAfterEdit(Control flxControl, int nRow, int nCol)
{
	string strNew = m_tplist.GetCell(nRow, nCol), strOld;
	TreeNode trSel = GetTreeNode(nRow);
	bool flag = trSel.GetAttribute(STR_LABEL_ATTRIB, strOld);
	if(!lstrlen(strOld))
		strOld = trSel.tagName;
	if(strNew.CompareNoCase(strOld) != 0)
	{
		TemplateOrganizer& tp=GetCurrentOrganizer(m_nSelRow, false);
		if(!tp.CategoryRename(trSel, strNew))
			m_tplist.SetCell(nRow, nCol, strOld);		
	}
	m_tplist.SetEditable(flexEDNone);
}
///End DBCLICK_RENAME
//------ Folger 10/22/07 QA70-10567 FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL
//void TPSplitter::CreatePageControl(TemplateOrganizer& tpOld, TemplateOrganizer& tpNew)
//{
	//Control& cCtrl=tpOld.GetCtrl();
	//if(cCtrl)
		//tpOld.DestroyControl();
	//
	//Control& cCtrl2 = tpNew.GetCtrl();
	//CreatePane(cCtrl2, PANE_ROW_COL_PAGE);
//}
//------- End FIX_BUGS_WHEN_CLASS_USED_IN_XF_HAS_DIALOG_OR_CONTROL

void TPSplitter::NewCategory()
{
	m_bReady = false;
	PROFILE_HRGLASS
	
	if(0 > m_nSelRow || inDelSection(m_nSelRow))
	{
		SetReady();
		m_bReady = true;
		return;
	}
	TreeNode trBranch = GetTreeNode(m_nSelRow);
	for(int nLevel = tree_get_level(trBranch); nLevel>TP_LEVEL_BRANCH; nLevel = tree_get_level(trBranch))
		trBranch = trBranch.Parent();	
		
	TemplateOrganizer& tp=GetCurrentOrganizer(m_nSelRow, false);	
	string strCategory;
	TreeNode trNewCate = tp.NewCategory(trBranch,strCategory);
	
	m_tplist.AddNewToList(trNewCate, m_nSelRow);
	
	SetReady();
	m_bReady = true;
	///Jasmine 07/03/07 ON_ROW_CHANGE_AFTER_SET_READY
	m_nSelRow = -1;
	Control ctrl;
	OnRowChange(ctrl);
	///End ON_ROW_CHANGE_AFTER_SET_READY
	return;
}
void TPSplitter::AddTemplate()
{
	m_bReady = false;
	PROFILE_HRGLASS
	
	if(0 > m_nSelRow || inDelSection(m_nSelRow))
	{
		SetReady();
		m_bReady = true;
		return;
	}
	TreeNode trCate = GetTreeNode(m_nSelRow);
	int nLevel = tree_get_level(trCate);
	
		
	
	if(TP_LEVEL_CATEGORY > nLevel)
		trCate = GetTreeNode(++m_nSelRow);
	else if(TP_LEVEL_CATEGORY < nLevel)
		trCate = trCate.Parent();
		
	TemplateOrganizer& tp=GetCurrentOrganizer(m_nSelRow, false);
	bool		bHasNewTempAdded = false; /// Hong 06/16/08 v8.0885 FIX_SPLITTER_GUI_FAIL_REFRESH_IF_USER_CANCEL
	vector<string> vsTempFile;		
	if(0 < tp.GetMultiOpenBox(vsTempFile))			
	{
		for(int ii=0; ii<vsTempFile.GetSize(); ii++)
		{
			///Jasmine 07/31/07 ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
			string strOld;
			TreeNode trTemplate = tp.AddTemplate(trCate, vsTempFile[ii], &strOld);
			if(!strOld.IsEmpty())
			{
				string strLabel, strType;
				string strExt = page_get_template_ext(tp.GetTemplateType(), strType);
				strLabel.Format(_L("%s Template (*%s)"), strType, strExt);
				int nRowStart = m_tplist.GetRow(strLabel);
				int nRowDel = m_tplist.GetRow(strOld, nRowStart);
				if(-1 != nRowDel)
				{
					m_tplist.DelSection(nRowDel);
					if(nRowDel <= m_nSelRow)
						m_nSelRow--;
				}
			}
			///End ADD_TEMPLATE_RESTRICT_IN_ONE_CATEGORY
			if(trTemplate.IsValid())
			{
				m_tplist.AddNewToList(trTemplate, m_nSelRow);
				bHasNewTempAdded = true; /// Hong 06/16/08 v8.0885 FIX_SPLITTER_GUI_FAIL_REFRESH_IF_USER_CANCEL
			}
		}
	}
	SetReady();
	m_bReady = true;
	///Jasmine 12/20/05 update picture
	if ( bHasNewTempAdded ) /// Hong 06/16/08 v8.0885 FIX_SPLITTER_GUI_FAIL_REFRESH_IF_USER_CANCEL
	{
		m_nSelRow = -1;
		Control ctrl;
		OnRowChange(ctrl);
	}
	///------ Folger 09/15/09 SPLITTER_CONTROL_MIXED_UP_AFTER_CLICK_CANCEL_FROM_ADD_DIALOG
	else
	{
		Window		win = GetParent();
		win.Visible = FALSE, win.Visible = TRUE;
	}
	///------ End SPLITTER_CONTROL_MIXED_UP_AFTER_CLICK_CANCEL_FROM_ADD_DIALOG

	return;
}
///Jasmine 11/21/05 QA70-8347 v8.0339 SAVE_FULL_PATH
///Jasmine 12/28/05 REMEMBER_LAST_SELECTION
//get row to save in register
string TPSplitter::GetSel(int& nRow)
{
	string strFileName;
	if(!m_bReady)
		return "";
	
	PROFILE_HRGLASS
	nRow = m_nSelRow;
	if(0 > nRow || inDelSection(nRow))
		return "";
	TemplateOrganizer& tpNew=GetCurrentOrganizer(nRow, true);
	TreeNode trNewNode=GetTreeNode(nRow);
///End REMEMBER_LAST_SELECTION
	if ( tpNew.IsTemplateNode(trNewNode) ) 	
	{
		bool flag = trNewNode.GetAttribute(STR_FILENAME_ATTRIB, strFileName);
	}
	return strFileName;
}
///End SAVE_FULL_PATH

//------ Folger 01/22/08 SHOULD_NOT_RENAME_CATEGORY_WITH_SYSTEM_OR_GROUP_TEMPLATE
string TPSplitter::GetCategoryDescription()
{
	string strDescription;
	TreeNode trNode = GetTreeNode(m_nSelRow);
	string strName;
	if ( tree_get_level(trNode) == TR_LEVEL_CATEGORY && !trNode.GetAttribute(STR_NAME_ATTRIB, strName) )
	{
		string strCategory;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strCategory);
		strDescription = isCategoryRenameable(strCategory, trNode.Parent().DataID) ? _L("Double click to rename") : "";
	}
	return strDescription;
}
//------

void TPSplitter::DelCateOrTemp()
{
	m_bReady = false;
	PROFILE_HRGLASS
	
	if(0 > m_nSelRow || inDelSection(m_nSelRow))
	{
		SetReady();
		m_bReady = true;
		return;
	}
	
	TreeNode trDel = GetTreeNode(m_nSelRow);
	TreeNode trParent = trDel.Parent();	
	int nLevel = tree_get_level(trDel);
	if(TP_LEVEL_CATEGORY > nLevel || inDelSection(m_nSelRow))//can not delete anything else
	{
		SetReady();
		m_bReady = true;
		return;
	}
		
	string strWarning = _L("Are you sure you want to delete this item?");
	if(IDNO == MessageBox(GetSafeHwnd(), strWarning, _L("Attention!"), MB_YESNO | MB_DEFBUTTON2 | MB_ICONEXCLAMATION))
	{
		SetReady();
		m_bReady = true;
		return;
	}	
	
	
	TemplateOrganizer& tp=GetCurrentOrganizer(m_nSelRow, false);
	if(TP_LEVEL_CATEGORY == nLevel)
	{
		if(2 > trParent.GetNodeCount())
		{
			string strError = _L("Can't delete last category!");
			MessageBox(GetSafeHwnd(), strError, _L("Attention!"), MB_OK | MB_ICONSTOP);
			SetReady();
			m_bReady = true;
			return ;
		}
		
		while(0 < trDel.GetNodeCount())
		{
			TreeNode trChild = trDel.FirstNode;
			TreeNode trSysTemp = tp.DelCateOrTemp(trDel, trChild);
			m_tplist.DelFromList(m_nSelRow + 1, trSysTemp);
		}		
	}	
	TreeNode trSysTemp = tp.DelCateOrTemp(trParent, trDel);
	m_tplist.DelFromList(m_nSelRow, trSysTemp);
	
	///------ Folger 05/27/09 QA80-11779 DELETE_USER_DEFINED_TEMPLATE_FROM_TEMPLATE_LIBRARY_SHOULD_REMOVE_FILE
	string		strFile;
	if ( trDel.GetAttribute(STR_FILENAME_ATTRIB, strFile) && ORIGIN_PATH_USER == okutil_template_get_origin_path_type(strFile) )
	{
		LPCSTR		lpcszDeletedFolder = "DeletedTemplates\\";
		string		strPath = GetFilePath(strFile);
		string		strName = GetFileName(strFile);
		string		strDesPath = strPath + lpcszDeletedFolder;
		
		CheckMakePath(strDesPath);
		copyfile(strFile, strDesPath + strName);
		DeleteFile(strFile);
		
		OptionalMessage("DeleteUserDefinedTemplate", MB_OK);
	}
	///------ End DELETE_USER_DEFINED_TEMPLATE_FROM_TEMPLATE_LIBRARY_SHOULD_REMOVE_FILE
	
	SetReady();
	m_bReady = true;
	///Jasmine 12/20/05	update picture
	m_nSelRow = -1;
	Control ctrl;
	OnRowChange(ctrl);
	return;
}
///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
bool TPSplitter::Restore(TreeNode& trSel)
{
	m_bReady = false;
	foreach(TreeNode trTemplate in trSel.Children)
		Restore(trTemplate);
	string strName, strExt, strCate, strFile, strINIFilePath = STR_USER_PATH + "template.ini";
	trSel.GetAttribute(STR_LABEL_ATTRIB, strName);
	trSel.GetAttribute(STR_CHANGED_ATTRIB, strCate);
	trSel.GetAttribute(STR_FILENAME_ATTRIB, strFile);
	//------ Folger 11/10/07 FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
	if (!strFile.IsFile())
		strFile = okutil_get_origin_path(ORIGIN_PATH_SYSTEM) + strName;
	//------ End FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
	if(!strName.CompareNoCase(STR_DELETE_SECTION) || !lstrlen(strCate))// || !strFile.IsFile())
		return true;
	if(!strFile.IsFile())
	{
		string strMsg; 
		strMsg.Format(_L("Fail to restore %s.\nFile %s is missing."), strName, strFile);
		MessageBox(GetSafeHwnd(), strMsg, _L("Error"), MB_OK | MB_ICONEXCLAMATION);
		int nDelBranchRow = m_tplist.GetRow(STR_DELETE_SECTION);
		int nRowDel = m_tplist.GetRow(strName, nDelBranchRow);
		if(-1 != nRowDel)
			m_tplist.DelSection(nRowDel);
		return false;
	}
	separate_file_name_ext(strName, &strName, &strExt);//check template type
	int nID = _get_template_type_from_ext(strExt), nRow;
	TemplateOrganizer& tp=GetOrganizer(nID, false);	
	TreeNode trBranch = tree_get_node_by_id(m_trTP, nID), trCate, trTemp;
	string strRowText;
	trBranch.GetAttribute(STR_LABEL_ATTRIB, strRowText);
	nRow = m_tplist.GetRow(strRowText);
	trCate = trBranch.FindNodeByAttribute(STR_LABEL_ATTRIB, strCate);
	if(!trCate.IsValid())
		trCate = trBranch.GetNode(strCate);
	if(!trCate.IsValid())//category is removed or renamed
	{
		trCate = tp.NewCategory(trBranch, strCate);
		m_tplist.AddNewToList(trCate, nRow);
	}
	//------ Folger 11/10/07 FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
	//trTemp = tp.AddTemplate(trCate, strFile);
	trTemp = tp.AddTemplate(trCate, strFile, NULL, true);
	//------ End FIX_BUGS_WHEN_RESORE_FROM_DELETED_SYSTEM_FILE
	nRow = m_tplist.GetRow(strCate, nRow);
	m_tplist.AddNewToList(trTemp, nRow);
	
	SetReady();
	m_bReady = true;
	m_nSelRow = m_tplist.GetRow(STR_DELETE_SECTION);
	m_tplist.SelRow(m_nSelRow);
	return true;
}
///End RESTORE_DEL_TEMPLATE
bool TPSplitter::inDelSection(int nRow)
{
	if(0 > nRow)
		return false;
	for(TreeNode tr=GetTreeNode(nRow); TP_LEVEL_BRANCH<tree_get_level(tr); tr=tr.Parent())
		;
	///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	if(!tr)
		return false;
	///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
	string strName;
	tr.GetAttribute(STR_LABEL_ATTRIB, strName);
	if(strName.CompareNoCase(STR_DELETE_SECTION))
		return false;
	return true;
}

int TPSplitter::GetMainPaneID()
{
	return m_IDTreePane;
}
int TPSplitter::GetPagePaneID()
{
	return m_IDPagePane;
}
TemplateOrganizer& TPSplitter::GetCurrentOrganizer(int nRow, bool SetAsCurrentOrganizer)
{
	int nIndex=0;//-1;	///Jasmine 07/25/06 ADD_DEFAULT_ORG_IN_ARRAY
	if(-1 == nRow)
	{
		nIndex=m_nCurOrganizerIndex;
	}
	else
	{
		TreeNode trNode=GetTreeNode(nRow);
		nIndex = getSelTPArrayIndex(trNode);
		if(SetAsCurrentOrganizer)
			m_nCurOrganizerIndex = nIndex;
	}
	return m_arrTP.GetAt(nIndex);
}
///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
TemplateOrganizer& TPSplitter::GetOrganizer(int nID, bool SetAsCurrentOrganizer)
{
	int nIndex = getSelTPArrayIndex(nID);
	if(SetAsCurrentOrganizer)
		m_nCurOrganizerIndex = nIndex;
	return m_arrTP.GetAt(nIndex);
}
///End RESTORE_DEL_TEMPLATE
TreeNode TPSplitter::GetTreeNode(int nRow)
{
	TreeNode tr;
	//temp code
	tr = tree_get_node(m_trTP, nRow);
	return tr;
}
int TPSplitter::getSelTPArrayIndex(TreeNode& trSelNode)
{
	///Jasmine 02/06/06 BLOCK_IN_DEL_SECTION
	int nDataID=-1;
	for(TreeNode trParent=trSelNode; trParent.IsValid(); trParent=trParent.Parent())
	{
		nDataID = trParent.DataID;
		if(-1 != nDataID)
			break;
	}
	//return nDataID;
///Jasmine 11/25/06 RESTORE_DEL_TEMPLATE
	return getSelTPArrayIndex(nDataID);
}
int TPSplitter::getSelTPArrayIndex(int nDataID)
{
	switch(nDataID)
	{
	case TP_TYPE_GRAPH:
	///Jasmine 07/25/06 ADD_DEFAULT_ORG_IN_ARRAY
		return 1;//0;
	case TP_TYPE_WORKBOOK:
		return 2;//1;
	case TP_TYPE_MATRIX:
		return 3;//2;
	}
	return 0;//-1;
	///End BLOCK_IN_DEL_SECTION
}
///End RESTORE_DEL_TEMPLATE
void TPSplitter::initOrganizerArray()
{
	m_arrTP.SetAsOwner(true);
	
	TemplateOrganizer* pTP;
	///Jasmine 07/31/07 MESSAGEBOX_SHOULD_USE_PARENT_HWND
	HWND hwnd = GetSafeHwnd();	
	pTP = new TemplateOrganizer(hwnd);
	int nRet=m_arrTP.Add(*pTP);
	pTP = NULL;	
	///End ADD_DEFAULT_ORG_IN_ARRAY
	pTP = new GraphTemplate(hwnd);
	nRet=m_arrTP.Add(*pTP);
	pTP = NULL;
	
	pTP = new WorkbookTemplate(hwnd);
	nRet=m_arrTP.Add(*pTP);
	pTP = NULL;
	///End MESSAGEBOX_SHOULD_USE_PARENT_HWND
	pTP = new MatrixTemplate(hwnd);
	nRet=m_arrTP.Add(*pTP);
	pTP = NULL;
}

//------ Folger 01/22/08 SHOULD_NOT_RENAME_CATEGORY_WITH_SYSTEM_OR_GROUP_TEMPLATE
bool TPSplitter::isCategoryRenameable(LPCSTR lpcszCategory, int nType)
{
	if ( lpcszCategory == NULL )
		return false;
	
	vector<string>	vsXMLPath;
	vsXMLPath.Add(STR_SYSTEM_TEMPLATE_XML);
	vsXMLPath.Add(STR_GROUP_TEMPLATE_XML);
	
	for ( int ii=0; ii<vsXMLPath.GetSize(); ++ii )
	{
		vector<string>	vsCategories;
		okutil_get_template_categories(vsXMLPath[ii], &vsCategories, nType);
		if ( vsCategories.Find(lpcszCategory) >= 0 )
			return false;
	}
	
	return true;
}
//------

//------ Folger 01/23/08 QA70-10980 MVOE_TEMPLATE_TO_SPECIFIC_CATEGORY
bool TPSplitter::isTemplateMoveable(const TreeNode &trTemplate)
{
	string strPath;
	if ( !trTemplate.GetAttribute(STR_FILENAME_ATTRIB, strPath) )
		return false;
	
	strPath = GetFilePath(strPath);
	string strSystem = okutil_get_origin_path(ORIGIN_PATH_SYSTEM);
	string strGroup = okutil_get_origin_path(ORIGIN_PATH_GROUP);
	
	if ( strPath.CompareNoCase(strSystem) ==0 || !strGroup.IsEmpty() && strPath.CompareNoCase(strGroup) == 0 )
		return false;
	
	return true;
}

bool TPSplitter::getCategories(vector<string> &vsCategories, const TreeNode &trBranch)
{
	foreach ( TreeNode trCategory in trBranch.Children )
	{
		string strName;
		trCategory.GetAttribute(STR_LABEL_ATTRIB, strName);
		vsCategories.Add(strName);
	}
	
	return true;
}
//------

///Kyle 03/18/2009 QA80-13299 SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER
void TPSplitter::ScanUserTemplates()
{
	m_bReady = false;
	bool bRowChanged = false;
	
	///Kyle 04/08/2009 QA80-13299 MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
	//TreeNode trUserCategory = m_arrTP.GetAt(getSelTPArrayIndex(TP_TYPE_GRAPH)).ScanUserTemplates(m_trTP);
	vector<int> vnTypes = {TP_TYPE_GRAPH, TP_TYPE_WORKBOOK, TP_TYPE_MATRIX};
	for(int ii=0; ii<vnTypes.GetSize(); ii++)
	{
		TreeNode trUserCategory = m_arrTP.GetAt(getSelTPArrayIndex(vnTypes[ii])).ScanUserTemplates(m_trTP);
	///End MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
		if(trUserCategory && trUserCategory.GetNodeCount())
		{
			string strLabel, strType;
			///Kyle 04/08/2009 QA80-13299 MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
			//string strExt = page_get_template_ext(TP_TYPE_GRAPH, strType);
			string strExt = page_get_template_ext(vnTypes[ii], strType);
			///End MORE_CODE_TO_SCAN_USER_WORKBOOK_AND_MATRIX_TEMPLATE
			strLabel.Format(_L("%s Template (*%s)"), strType, strExt);
			int nRowStart = m_tplist.GetRow(strLabel);
			if(nRowStart >= 0)			// graph
			{
				int nState = flexOutlineCollapsed;
	
				string strCategory;
				trUserCategory.GetAttribute(STR_LABEL_ATTRIB, strCategory);
				int nRowDel = m_tplist.GetRow(strCategory, nRowStart);
				if(nRowDel >= 0)
				{
					nState = m_tplist.GetCollapsed(nRowDel);
					m_tplist.DelSection(nRowDel);
				}
				int nRowToAdd = nRowStart;
				m_tplist.AddNewToList(trUserCategory, nRowToAdd);
	
				int nRowAdd = m_tplist.GetRow(strCategory, nRowStart);
				ASSERT(nRowAdd >= 0);
				m_tplist.SetCollapsed(nRowAdd, nState);
	
				bRowChanged = true;
			}
		}
	}
	
	SetReady();
	m_bReady = true;
	if ( bRowChanged )
	{
		m_nSelRow = -1;
		Control ctrl;
		OnRowChange(ctrl);
	}
}
///End SCAN_GRAPH_TEMPLATE_IN_USER_FILES_FOLDER

//---- CPY 10/5/05 CLASS_FORWARD_DECLARATION_MUST_USE_PTR

TemplateOrganizerDlg::TemplateOrganizerDlg() : ResizeDialog(IDD_TP_DLG, "ODlg8")
{
	m_psplitter = new TPSplitter;
}

TemplateOrganizerDlg::~TemplateOrganizerDlg()
{
	delete m_psplitter;
}

//----



//----- CPY 12/30/05 QA70-8347 REPLACE_TEMPLATE_LIB_WITH_TEMPLATE_ORGANIZER
/*
int TPOpen()
{
	string strPath;
	TemplateOrganizerDlg	TODlg();
	int nRet = TODlg.DoModalEx( GetWindow(), strPath );
	return 0;
}
*/

/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
BOOL ProjectBrowseTemplate(string& strResult, int nPageType, HWND hWnd)
{
	string strTemplate;
	TemplateOrganizerDlg	TODlg();
	if( IDCANCEL != TODlg.DoModalEx( hWnd, strTemplate, NULL, FALSE, nPageType, NULL, TRUE) )
	{
		strResult = strTemplate;
		return TRUE;
	}
	
	return FALSE;
}
/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL


///Jasmine 08/17/06 CLEAN_UP_CODE
//I don't use  file_time_compare(LPCSTR lpczFile1, LPCSTR lpczFile2, DWORD dwOption = CREATION_TIME) here 
//for it return -1 if lpczFile1 or lpczFile2 is not file
//------ Folger 09/04/07 USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL
//static bool _file_modified_time_compare(string strFile1, string strFile2)
//{
	//string strDate1 = GetFileModificationDate(strFile1, LDF_YYMMDD_AND_HHMMSS);
	//string strDate2 = GetFileModificationDate(strFile2, LDF_YYMMDD_AND_HHMMSS);
	//return strDate1.CompareNoCase(strDate2) >= 0;
	////return false if strFile2 modified time is newer than strFile1 or strFile1 isn't file.
	////else return true
//}
//------ End USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL
//--CPY 4/4/08 TEMPLATE_SAVE_BROKEN_DUE_TO_FUNC_NOT_FOUND
// moved to .h as I found Templte Save and Save As generated runtime error
/*
//export image if a template to emf or bmp file
static BOOL _extract_template_to_image(LPCSTR lpcszTemplate, LPCSTR lpcszImage)
{
	string strImage(lpcszImage);
	string strExt = strImage.GetToken(1,'.');
	
	int	nOption = CREATE_NO_REMOVE_TEMPLATEPICT;
	GraphPage grph;
	grph.Create(lpcszTemplate, nOption);
	GraphLayer lay = grph.Layers(0);
	GraphObject	grPict;
	grPict = lay.GraphObjects("Template" + strExt);
	BOOL bRet = FALSE;
	if(grPict.IsValid())
		bRet = grPict.ExtractImageToFile(lpcszImage);
	grph.Destroy();
	return bRet;
}*/

//------ Folger 09/29/07 NEW_DISIGN_FOR_SAVING_TEMPLATE_XML
static void _remove_template_label_attribue(TreeNode &tr)
{
	if(!tr)
		return;
	
	foreach(TreeNode trBranch in tr.Children)
	{
		foreach(TreeNode trCategory in trBranch.Children)
		{
			octree_remove_attribute(&trCategory, STR_LABEL_ATTRIB);
		}
	}
}
//------ End NEW_DISIGN_FOR_SAVING_TEMPLATE_XML



#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

///Kyle 04/15/2009 QA80-13405 CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_IT
enum LegendType
{
	LEGEND_TYPE_NONE,
	LEGEND_TYPE_LEGEND,
	LEGEND_TYPE_SPECTRUM,
};
///End CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_IT

void OpenTemplateOrganizer(BOOL bMakePlot)
{
	string strTemplate;
	TemplateOrganizerDlg	TODlg();
	HWND hWnd = GetWindow();
	int nSelPlotType = 0;
	///Jasmine 09/11/07 COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
#ifdef COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
	int nPageType = EXIST_NONE;
#else
	//------ Folger 01/23/08 QA70-10980 ADD_NEW_TEMPLATE_AND_NEW_CATEGORY_BUTTON
	//int nPageType = bMakePlot? EXIST_PLOT : EXIST_NONE;
	int nPageType = EXIST_NONE;
	//------
#endif//COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
	bool bShowPlotSetupButton = true;//bMakePlot? false:true;
	int nRet = TODlg.DoModalEx( hWnd, strTemplate, NULL, bShowPlotSetupButton, nPageType, &nSelPlotType);
	if(nRet != IDCANCEL)
	{
		
///Jasmine 09/11/07 COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
#ifdef COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
		if(nSelPlotType)
#else
		if(bMakePlot && nSelPlotType) // indicate to open PlotSetup, or to directly make plot (IDOK)
#endif//COMBINE_TEMPLATE_LIBRARY_AND_ORGANIZER
		{
			if(nRet == IDOK) // plot immediately
			{
				///------ Folger 12/22/08 QA80-12807-S3 v8.0989c ADD_MENU_MRU_LIST_FOR_MATRIX
				PageBase pg = Project.Pages();
				///------ End ADD_MENU_MRU_LIST_FOR_MATRIX
				string strLT;
				///Kyle 03/27/2009 TEMPORARY_SOLUTION_TO_GET_PLOT_TYPE_FROM_TEMPLATE
				//strLT.Format("worksheet -P ? \"%s\";legend -s", strTemplate);
				int nLegendOrSpectrum = LEGEND_TYPE_NONE; // 1 for legend and 2 for spectrum				///Kyle 04/15/2009 QA80-13405 CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_IT
				DWORD dwLayerBits = 0;
				if(nSelPlotType == 0 || nSelPlotType == IDM_PLOT_UNKNOWN)
				{
					GraphPage gp;
					/// Kenny 08/25/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
					//if(gp.Create(strTemplate, CREATE_HIDDEN))
					if(gp.Create(strTemplate, CREATE_HIDDEN|CREATE_ENUM_EXIST_PAGE))
					/// End QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
					{
						Tree trPlots;
						nSelPlotType = gpage_get_plots(gp, trPlots);
						///Kyle 04/01/2009 HANDLE_SPECIAL_PLOT_TYPE_IN_TEMPLATE_ORGANIZER
						TreeNode trLayer;
						if(trPlots.DataPlots)
							trLayer = trPlots.DataPlots.Layer0;
						string strTemp;
						if(trLayer && trLayer.GetAttribute(STR_LAYER_TYPE_BITS, strTemp) )
						{
							dwLayerBits = atoi(strTemp);
							if(dwLayerBits == PCD_LAYER_TRI)
							{
								///Jasmine 09/07/09 QA81-14237-P6 BASE_TYPE_IDM_PLOT_TRI_CONTOUR_AND_LAYER_BIT_PCD_LAYER_TRI_MEAN_IDM_PLOT_TERNARY_CONTOUR
								if(IDM_PLOT_TRI_CONTOUR == nSelPlotType)
									nSelPlotType = IDM_PLOT_TERNARY_CONTOUR;
								else
									nSelPlotType = IDM_PLOT_XYZ_TRIANGULAR;
								///End BASE_TYPE_IDM_PLOT_TRI_CONTOUR_AND_LAYER_BIT_PCD_LAYER_TRI_MEAN_IDM_PLOT_TERNARY_CONTOUR
							}
							///Jasmine 10/22/09 QA81-14470-P3 RX_THETAY_POLAR_GRAPH_NEED_PLOT_ID_FROM_STYLE_HOLDER
							else if(dwLayerBits == PCD_LAYER_POLAR)
							{
								DWORD dw = 0;
								TreeNode trStyleHolder = tree_get_node_by_tagname(trLayer, "StyleHolder1", true);
								if(trStyleHolder)
									dw = trStyleHolder.PlotDesigs.AuxPlotInfo.nVal;
								if(dw & PCD_POLAR_SWAPPED)
									nSelPlotType = IDM_PLOT_POLAR_XR_YTHETA;
							}
							///End RX_THETAY_POLAR_GRAPH_NEED_PLOT_ID_FROM_STYLE_HOLDER
						}
						///End HANDLE_SPECIAL_PLOT_TYPE_IN_TEMPLATE_ORGANIZER
						///Kyle 04/15/2009 QA80-13405 CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_IT
						GraphLayer gl = gp.Layers();
						if(gl)
						{
							GraphObject go;
							go = gl.GraphObjects("Spectrum1");
							if(go)
								nLegendOrSpectrum = LEGEND_TYPE_SPECTRUM;
							else if(gl.GraphObjects(GO_LEGEND_NAME))
								nLegendOrSpectrum = LEGEND_TYPE_LEGEND;
						}
						///End CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_IT
						gp.Destroy();
					}
				}
				///Kyle 04/15/2009 QA80-13405 CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_IT
				//if(nSelPlotType == 0 || nSelPlotType == IDM_PLOT_UNKNOWN)
				//	strLT.Format("worksheet -P ? \"%s\";legend -s", strTemplate);
				//else
				//	strLT.Format("worksheet -P %d \"%s\";legend -s", nSelPlotType, strTemplate);
				/// ML 5/8/2009 QA70-13584 MUST_PASS_QUESTIONMARK_FOR_PROPER_PLOT_CREATION
				//if(nSelPlotType == 0 || nSelPlotType == IDM_PLOT_UNKNOWN)
				//	strLT.Format("worksheet -P ? \"%s\"", strTemplate);
				//else
				//	strLT.Format("worksheet -P %d \"%s\"", nSelPlotType, strTemplate);
				BOOL		bUse_QuestionMark = TRUE;
				switch ( nSelPlotType )
				{
				///Jasmine 10/15/09 QA81-14470 WINDROSE_NEED_PLOTTYPE_COLUMN_STACK
				case IDM_PLOT_COLUMN_STACK:
					if( dwLayerBits == PCD_LAYER_POLAR )
						bUse_QuestionMark = FALSE;
					break;
				///End WINDROSE_NEED_PLOTTYPE_COLUMN_STACK
				case IDM_PLOT_POLAR_XR_YTHETA:		///Jasmine 10/22/09 QA81-14470-P3 RX_THETAY_POLAR_GRAPH_NEED_PLOT_ID_FROM_STYLE_HOLDER
				case IDM_PLOT_3D_LINE:
				case IDM_PLOT_TRI_CONTOUR:
					//	The VC code (on_after_add_plots()) does not check the "groupedness" of style holders
					//	unless '?' is passed, hence the bug 13584. On the other hand, see QA70-12248, certain
					//	types require the plot type id to be passed. So, here I pass id for those only by
					//	setting bUse_QuestionMark to FALSE.
				case IDM_PLOT_XYZ_TRIANGULAR:		///Jasmine 07/27/09 QA80-P3 TERNARY_PLOT_NEED_PLOT_TYPE_ID
				case IDM_PLOT_TERNARY_CONTOUR:
					bUse_QuestionMark = FALSE;
					break;
				}
				
				///------ Folger 09/24/09 XF_BASED_PLOTTING_FROM_TEMPLATE_LIBRARY_ALWAYS_UPDATE_UNKNOW_KEYWORD_INTO_PLOTTING_MRU
				///// Iris 8/07/2009 NEED_ADD_WINDROSERAW_TO_TEMPLATE_LIB
				//GraphPage gpTemp;
				//gpTemp.Create(strTemplate, CREATE_SET_MISSING_IN_MANAGER);			
				//gpTemp.LT_execute("xfinfo$ = page.info.system.plotting.xfunction$");
				//char    szPageXFInfo[200];
				//LT_get_str("xfinfo$", szPageXFInfo, 200);
				//gpTemp.Destroy();
				//if( 0 != lstrlen(szPageXFInfo) )
				//{
					//strTemplate = GetFileName(strTemplate, true);
					//strLT.Format("worksheet -PX ? %s %s", strTemplate, szPageXFInfo);
				//}
				//else
				/////end NEED_ADD_WINDROSERAW_TO_TEMPLATE_LIB
				///------ End XF_BASED_PLOTTING_FROM_TEMPLATE_LIBRARY_ALWAYS_UPDATE_UNKNOW_KEYWORD_INTO_PLOTTING_MRU
				{
					if ( bUse_QuestionMark )
						strLT.Format("worksheet -P ? \"%s\"", strTemplate);
					else
						strLT.Format("worksheet -P %d \"%s\"", nSelPlotType, strTemplate);
				}
				/// end MUST_PASS_QUESTIONMARK_FOR_PROPER_PLOT_CREATION
				if(nLegendOrSpectrum == LEGEND_TYPE_LEGEND)
					strLT += ";legend -s";
				else if(nLegendOrSpectrum == LEGEND_TYPE_SPECTRUM)
					strLT += ";spectrum";
				///End CHECKING_IF_LEGEND_OR_SPECTRUM_EXIST_BEFORE_UPDATING_IT
				///End TEMPORARY_SOLUTION_TO_GET_PLOT_TYPE_FROM_TEMPLATE
				
				///Jasmine 01/15/10 LAST_SEL_BLOCK_PLOTSETUP_OPEN, remove selection is work for wks but not for matrix, so I have to reset %E
				string strBackupLT;	
				GraphPage gp = Project.Pages();
				if(gp)
				{					
					strBackupLT.Format("%s$ = %%E; %%E=\"\"", TEMP_LT_VAR_LAST_SEL);
					LT_execute(strBackupLT);
				}
				///End LAST_SEL_BLOCK_PLOTSETUP_OPEN
				LT_execute(strLT);
				
				///Jasmine 01/15/10 LAST_SEL_BLOCK_PLOTSETUP_OPEN
				strBackupLT.Format("if( exist(%s$) ){%%E = %s$; del -vs %s}", TEMP_LT_VAR_LAST_SEL, TEMP_LT_VAR_LAST_SEL, TEMP_LT_VAR_LAST_SEL);
				LT_execute(strBackupLT);
				///End LAST_SEL_BLOCK_PLOTSETUP_OPEN
				
				///------ Folger 12/17/08 QA80-12749 v8.0987d PLOT_MRU_LIST_SHOULD_UPDATE_THAT_PLOTS_IN_TEMPLATE_LIBRARY
				UpdatePlotMRUTemplateItem(strTemplate, pg ? pg.GetType() : EXIST_WKS);
				///------ End PLOT_MRU_LIST_SHOULD_UPDATE_THAT_PLOTS_IN_TEMPLATE_LIBRARY
			}
			else
				TODlg.LanchPlotSetupDlg(nSelPlotType, hWnd);
		}
	}
}
//-----
							
///Jasmine 10/22/09 QA81-14470-P3 RX_THETAY_POLAR_GRAPH_NEED_PLOT_ID_FROM_STYLE_HOLDER
//some code is duplicated from OpenTemplateOrganizer, should centralize after 8.1 release
static bool _get_special_plot_id(LPCSTR lpcszTemplate, int& nSelPlotType)
{
	nSelPlotType = IDM_PLOT_UNKNOWN;
	GraphPage gp;
	if(gp.Create(lpcszTemplate, CREATE_HIDDEN|CREATE_ENUM_EXIST_PAGE))					
	{
		Tree trPlots;
		nSelPlotType = gpage_get_plots(gp, trPlots);
		
		///Kyle 04/01/2009 HANDLE_SPECIAL_PLOT_TYPE_IN_TEMPLATE_ORGANIZER
		TreeNode trLayer;
		if(trPlots.DataPlots)
			trLayer = trPlots.DataPlots.Layer0;
		
		string strTemp;
		if(trLayer && trLayer.GetAttribute(STR_LAYER_TYPE_BITS, strTemp) )
		{
			DWORD dwLayerBits = atoi(strTemp);
			if(dwLayerBits == PCD_LAYER_POLAR)
			{
				DWORD dw = 0;
				TreeNode trStyleHolder = tree_get_node_by_tagname(trLayer, "StyleHolder1", true);
				if(trStyleHolder)
					dw = trStyleHolder.PlotDesigs.AuxPlotInfo.nVal;
				if(dw & PCD_POLAR_SWAPPED)
					nSelPlotType = IDM_PLOT_POLAR_XR_YTHETA;
			}
		}
		///End HANDLE_SPECIAL_PLOT_TYPE_IN_TEMPLATE_ORGANIZER
		
		gp.Destroy();
	}
	
	if(nSelPlotType == IDM_PLOT_POLAR_XR_YTHETA)
		return true;
	
	return false;		
}
///End RX_THETAY_POLAR_GRAPH_NEED_PLOT_ID_FROM_STYLE_HOLDER